/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5134;
import net.minecraft.class_746;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.ducks.IECamera;
import qouteall.imm_ptl.core.portal.Portal;

public class ScaleUtils {
    public static final class_2960 IPORTAL_SCALING = class_2960.method_60655((String)"iportal", (String)"scaling");

    @Environment(value=EnvType.CLIENT)
    public static void onClientPlayerTeleported(Portal portal) {
        if (portal.hasScaling() && portal.isTeleportChangesScale()) {
            class_310 client = class_310.method_1551();
            class_746 player = client.field_1724;
            Validate.notNull((Object)player, (String)"Player is null", (Object[])new Object[0]);
            ScaleUtils.doScalingForEntity((class_1297)player, portal);
            IECamera camera = (IECamera)client.field_1773.method_19418();
            camera.ip_setCameraY((float)((double)camera.ip_getCameraY() * portal.getScaling()), (float)((double)camera.ip_getLastCameraY() * portal.getScaling()));
        }
    }

    public static void onServerEntityTeleported(class_1297 entity, Portal portal) {
        if (portal.hasScaling() && portal.isTeleportChangesScale()) {
            ScaleUtils.doScalingForEntity(entity, portal);
            if (entity.method_5854() != null) {
                ScaleUtils.doScalingForEntity(entity.method_5854(), portal);
            }
        }
    }

    @Nullable
    public static class_1324 getScaleAttr(class_1297 entity) {
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            return livingEntity.method_6127().method_45329(class_5134.field_47760);
        }
        return null;
    }

    public static double getScale(class_1297 entity) {
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            return livingEntity.method_55693();
        }
        return 1.0;
    }

    public static double getBaseScale(class_1297 entity) {
        class_1324 scaleAttr = ScaleUtils.getScaleAttr(entity);
        if (scaleAttr != null) {
            return scaleAttr.method_6201();
        }
        return 1.0;
    }

    public static double getIPortalScaling(class_1297 entity) {
        class_1324 scaleAttr = ScaleUtils.getScaleAttr(entity);
        if (scaleAttr == null) {
            return 1.0;
        }
        class_1322 modifier = scaleAttr.method_6199(IPORTAL_SCALING);
        if (modifier == null) {
            return 1.0;
        }
        return modifier.comp_2449() + 1.0;
    }

    public static void setIPortalScaling(class_1297 entity, double newScale) {
        class_1324 scaleAttr = ScaleUtils.getScaleAttr(entity);
        if (scaleAttr == null) {
            return;
        }
        if (Math.abs(newScale - 1.0) < 1.0E-4) {
            scaleAttr.method_6200(IPORTAL_SCALING);
            entity.method_18382();
            return;
        }
        scaleAttr.method_61163(new class_1322(IPORTAL_SCALING, newScale - 1.0, class_1322.class_1323.field_6331));
        entity.method_18382();
    }

    public static void setBaseScale(class_1297 entity, double scale) {
        class_1324 scaleAttr = ScaleUtils.getScaleAttr(entity);
        if (scaleAttr != null) {
            scaleAttr.method_6192(scale);
            entity.method_18382();
        }
    }

    public static double computeThirdPersonScale(class_1297 entity) {
        return ScaleUtils.getScale(entity);
    }

    public static double computeBlockReachScale(class_1297 entity) {
        return ScaleUtils.getScale(entity);
    }

    public static double computeMotionScale(class_1297 entity) {
        return ScaleUtils.getScale(entity);
    }

    private static void doScalingForEntity(class_1297 entity, Portal portal) {
        class_243 eyePos = McHelper.getEyePos(entity);
        class_243 lastTickEyePos = McHelper.getLastTickEyePos(entity);
        double oldScale = ScaleUtils.getIPortalScaling(entity);
        double newScale = ScaleUtils.transformScale(portal, oldScale);
        if (!entity.method_37908().field_9236 && ScaleUtils.isScaleIllegal(newScale)) {
            newScale = 1.0;
            entity.method_43496((class_2561)class_2561.method_43470((String)"Scale out of range"));
        }
        ScaleUtils.setIPortalScaling(entity, newScale);
        if (!entity.method_37908().field_9236) {
            McHelper.setEyePos(entity, eyePos, lastTickEyePos);
            McHelper.updateBoundingBox(entity);
        } else {
            McHelper.setEyePos(entity, eyePos, lastTickEyePos);
            McHelper.updateBoundingBox(entity);
        }
    }

    private static double transformScale(Portal portal, double oldScale) {
        double result = oldScale * portal.getScaling();
        if (Math.abs(result - 1.0) < 1.0E-4) {
            result = 1.0;
        }
        return result;
    }

    private static boolean isScaleIllegal(double scale) {
        return scale > (double)IPGlobal.scaleLimit || scale < 1.0 / (double)(IPGlobal.scaleLimit * 2);
    }
}

